<?php

namespace SV\StickyThreadOrder\XF\Pub\Controller;

use SV\StickyThreadOrder\XF\Service\Thread\Editor as ExtendedThreadEditor;

/**
 * @Extends \XF\Pub\Controller\Thread
 */
class Thread extends XFCP_Thread
{
    /** @noinspection PhpMissingReturnTypeInspection */
    protected function setupThreadEdit(\XF\Entity\Thread $thread)
    {
        /** @var ExtendedThreadEditor $editor */
        $editor = parent::setupThreadEdit($thread);

        /** @var \SV\StickyThreadOrder\XF\Entity\Thread $thread */
        if ($thread->sticky && $thread->canStickyOrderThread())
        {
            $stickThreadOrder = $this->filter('sticky_order', '?uint');
            $editor->setStickyThreadOrder($stickThreadOrder);
        }

        return $editor;
    }
}