<?php

namespace SV\StickyThreadOrder\XF\Pub\Controller;

use SV\StickyThreadOrder\XF\Service\Thread\Creator as ExtendedThreadCreator;

/**
 * @Extends \XF\Pub\Controller\Forum
 */
class Forum extends XFCP_Forum
{
    /** @noinspection PhpMissingReturnTypeInspection */
    protected function setupThreadCreate(\XF\Entity\Forum $forum)
    {
        /** @var ExtendedThreadCreator $creator */
        $creator = parent::setupThreadCreate($forum);

        /** @var \SV\StickyThreadOrder\XF\Entity\Thread $thread */
        $thread = $creator->getThread();

        $setOptions = $this->filter('_xfSet', 'array-bool');
        if (isset($setOptions['sticky']) &&
            $thread->sticky &&
            $thread->canStickyOrderThread())
        {
            $stickThreadOrder = $this->filter('sticky_order', '?uint');
            $creator->setStickyThreadOrder($stickThreadOrder);
        }

        return $creator;
    }
}