<?php

namespace SV\StickyThreadOrder\XF\Finder;

use function array_unshift;

/**
 * @Extends \XF\Finder\Thread
 */
class Thread extends XFCP_Thread
{
    public $armStickyHackOrdering = false;

    protected function writeSqlCondition($condition)
    {
        parent::writeSqlCondition($condition);

        // such a hack
        if ($this->armStickyHackOrdering)
        {
            if ($condition === '`xf_thread`.`sticky` = 1')
            {
                $this->armStickyHackOrdering = false;
                $displayOrder = $this->columnSqlName('StickyOrder.display_order', false);
                if (!$this->order && $this->defaultOrder)
                {
                    $this->order($this->defaultOrder);
                }
                array_unshift($this->order, "IFNULL($displayOrder, 1000)");
            }
            else if ($condition === '`xf_thread`.`sticky` = 0')
            {
                $this->armStickyHackOrdering = false;
            }
        }
    }
}