<?php

namespace SV\StickyThreadOrder\XF\Entity;

use SV\StickyThreadOrder\Entity\StickyThreadOrder;
use XF\Mvc\Entity\Structure;
use XF\Phrase;

/**
 * @Extends \XF\Entity\Thread
 *
 * @property int|null $sticky_thread_order Requires the StickyOrder to already be loaded
 *
 * @property-read StickyThreadOrder $StickyOrder
 */
class Thread extends XFCP_Thread
{
    public function setStickyThreadOrder(?int $order): void
    {
        if ($order)
        {
            /** @var StickyThreadOrder $stickyOrder */
            $stickyOrder = $this->getRelationOrDefault('StickyOrder');
            $stickyOrder->display_order = $order;
        }
        else
        {
            if ($this->StickyOrder)
            {
                $this->StickyOrder->delete();
            }
        }

        $this->clearCache('sticky_thread_order');
    }

    public function getStickyThreadOrder(): ?int
    {
        if (!$this->StickyOrder)
        {
            return null;
        }

        return $this->StickyOrder->display_order;
    }

    /**
     * @param Phrase|string|null $error
     * @return bool
     */
    public function canStickyOrderThread(&$error = null): bool
    {
        return $this->canEdit($error) && $this->canStickUnstick($error);
    }

    protected function _postSave()
    {
        parent::_postSave();
        if ($this->isChanged('sticky') && !$this->sticky)
        {
            if ($this->StickyOrder)
            {
                $this->StickyOrder->delete();
                $this->clearCache('sticky_thread_order');
            }
        }
    }

    protected function _postDelete()
    {
        parent::_postDelete();
        $this->db()->query('DELETE FROM xf_sv_sticky_thread_order WHERE thread_id = ?', $this->thread_id);
    }

    /**
     * @param Structure $structure
     * @return Structure
     * @noinspection PhpMissingReturnTypeInspection
     */
    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);

        $structure->getters['sticky_thread_order'] = true;

        $structure->relations['StickyOrder'] = [
            'entity'     => 'SV\StickyThreadOrder:StickyThreadOrder',
            'type'       => self::TO_ONE,
            'conditions' => 'thread_id',
            'primary'    => true
        ];

        return $structure;
    }
}