<?php

namespace SV\StickyThreadOrder;

use SV\StandardLib\InstallerHelper;
use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class Setup extends AbstractSetup
{
    use InstallerHelper;
    use StepRunnerInstallTrait;
    use StepRunnerUpgradeTrait;
    use StepRunnerUninstallTrait;

    public function installStep1(): void
    {
        $sm = $this->schemaManager();

        foreach ($this->getTables() as $tableName => $callback)
        {
            $sm->createTable($tableName, $callback);
            $sm->alterTable($tableName, $callback);
        }
    }

    public function upgrade2000000Step1(): void
    {
        $this->migrateTable('sticky_thread_order', 'xf_sv_sticky_thread_order');
    }

    public function upgrade2000000Step2(): void
    {
        $this->installStep1();
    }

    public function uninstallStep1(): void
    {
        $sm = $this->schemaManager();

        foreach ($this->getTables() as $tableName => $callback)
        {
            $sm->dropTable($tableName);
        }
    }

    protected function getTables(): array
    {
        $tables = [];

        $tables['xf_sv_sticky_thread_order'] = function ($table) {
            /** @var Alter|Create $table */
            $this->addOrChangeColumn($table, 'thread_id', 'int');
            $this->addOrChangeColumn($table, 'display_order', 'int')->setDefault(0);
            $table->addPrimaryKey('thread_id');
            if ($table instanceof Alter)
            {
                $table->dropIndexes('thread_id_display_order');
            }
        };

        return $tables;
    }
}
