<?php

namespace SV\StickyThreadOrder\Entity;

use SV\StickyThreadOrder\XF\Entity\Thread;
use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Structure;

/**
 * @property int $thread_id
 * @property int $display_order
 *
 * @property-read Thread $Thread
 */
class StickyThreadOrder extends Entity
{
    /**
     * Verifies the display order is smaller than 1000 (as size of input box is 3).
     */
    public function verifyDisplayOrder(int &$displayOrder): bool
    {
        if ($displayOrder > 999)
        {
            $displayOrder = 999;
        }

        return true;
    }

    public static function getStructure(Structure $structure): Structure
    {
        $structure->table = 'xf_sv_sticky_thread_order';
        $structure->shortName = 'SV\StickyThreadOrder:StickyThreadOrder';
        $structure->primaryKey = 'thread_id';
        $structure->columns = [
            'thread_id'     => ['type' => self::UINT, 'required' => true],
            'display_order' => ['type' => self::UINT, 'required' => true]
        ];
        $structure->relations = [
            'Thread' => [
                'entity'     => 'XF:Thread',
                'type'       => self::TO_ONE,
                'conditions' => 'thread_id',
                'primary'    => true
            ]
        ];
        $structure->options = [
            //'log_moderator' => true
        ];

        return $structure;
    }
}