;((window, document) =>
{
	'use strict'

	XF.NoteEdit = XF.Element.newHandler({
		options: {
			href: true,
			replace: null,
		},

		init ()
		{
			XF.on(this.target, 'ajax-submit:before', XF.proxy(this, 'beforeSubmit'))
			XF.on(this.target, 'ajax-submit:response', XF.proxy(this, 'handleResponse'))
			this.inserter = new XF.Inserter(this.target, this.options)
		},

		beforeSubmit ()
		{
			const ctrl = document.createElement('input')
			ctrl.type = 'hidden'
			ctrl.name = 'NoteEdit'
			ctrl.value = '1'

			const controls = this.target.querySelector('.js-controls')
			controls.appendChild(ctrl)
		},

		handleResponse (e)
		{
			const { data } = e
			if (data.errors || data.exception)
			{
				return
			}

			this.inserter.onLoad(data)
		},
	})

	XF.Element.register('note-edit', 'XF.NoteEdit')
})(window, document)
