<?php
// FROM HASH: 114f9099893ebdea7ef6c05c3e951b75
return array(
'code' => function($__templater, array $__vars, $__extensions = null)
{
	$__finalCompiled = '';
	$__templater->pageParams['pageTitle'] = $__templater->preEscaped('Enhanced search');
	$__finalCompiled .= '

';
	if ($__vars['es']) {
		$__templater->pageParams['pageAction'] = $__templater->preEscaped('
	' . $__templater->button('Reconfigure', array(
			'href' => $__templater->func('link', array('enhanced-search/config', ), false),
			'icon' => 'config',
			'overlay' => 'true',
		), '', array(
		)) . '
');
	}
	$__finalCompiled .= '

';
	if ($__vars['reindex']) {
		$__finalCompiled .= '
	<div class="blockMessage blockMessage--success blockMessage--iconic">
		' . 'Your changes have been saved. To finish this action, you must now <a href="' . $__templater->func('link', array('tools/rebuild', ), true) . '">rebuild the search index</a>.' . '
	</div>
';
	}
	$__finalCompiled .= '

';
	if ($__vars['es']) {
		$__finalCompiled .= '
	';
		if (!$__vars['xf']['options']['xfesEnabled']) {
			$__finalCompiled .= '
		<div class="blockMessage blockMessage--important blockMessage--iconic">
			' . 'Enhanced search is not currently enabled. Searches are not using it.' . '
		</div>
	';
		}
		$__finalCompiled .= '

	';
		if (!$__vars['version']) {
			$__finalCompiled .= '
		<div class="blockMessage blockMessage--error blockMessage--iconic">
			' . 'The Elasticsearch server could not be reached. Please check that the server is running.' . '
		</div>
	';
		} else if (!$__templater->test($__vars['testError'], 'empty', array())) {
			$__finalCompiled .= '
		<div class="blockMessage blockMessage--error blockMessage--iconic">
			' . $__templater->escape($__vars['testError']) . '
		</div>
	';
		}
		$__finalCompiled .= '

	<div class="block">
		<div class="block-container">
			<div class="block-body">
				';
		$__compilerTemp1 = '';
		if ($__vars['xf']['options']['xfesEnabled']) {
			$__compilerTemp1 .= '
						' . 'Yes' . '
						' . $__templater->button('Disable', array(
				'href' => $__templater->func('link', array('enhanced-search/toggle', ), false),
				'data-xf-click' => 'overlay',
			), '', array(
			)) . '
					';
		} else {
			$__compilerTemp1 .= '
						' . 'No' . '
						' . $__templater->button('Enable', array(
				'href' => $__templater->func('link', array('enhanced-search/toggle', ), false),
				'data-xf-click' => 'overlay',
			), '', array(
			)) . '
					';
		}
		$__finalCompiled .= $__templater->formRow('
					' . $__compilerTemp1 . '
				', array(
			'label' => 'Enabled',
			'rowtype' => 'button',
		)) . '
				';
		$__compilerTemp2 = '';
		if ($__vars['config']['https']) {
			$__compilerTemp2 .= '
						';
			if ($__vars['config']['verify'] === false) {
				$__compilerTemp2 .= '
							' . 'SSL certificate verification is disabled.' . '
						';
			} else {
				$__compilerTemp2 .= '
							' . 'SSL certificate verification is enabled.' . '

							';
				if ($__vars['config']['verify'] !== null) {
					$__compilerTemp2 .= '
								' . $__vars['xf']['language']['parenthesis_open'] . 'Custom bundle: ' . $__templater->escape($__vars['config']['verify']) . '' . $__vars['xf']['language']['parenthesis_close'] . '
							';
				}
				$__compilerTemp2 .= '
						';
			}
			$__compilerTemp2 .= '
					';
		}
		$__vars['serverExplain'] = $__templater->preEscaped('
					' . $__compilerTemp2 . '
				');
		$__finalCompiled .= '
				' . $__templater->formRow('

					' . $__templater->escape($__vars['es']['printableBaseUrl']) . '
				', array(
			'label' => 'Elasticsearch server',
			'explain' => $__templater->escape($__vars['serverExplain']),
		)) . '

				';
		if ($__vars['version']) {
			$__finalCompiled .= '
					' . $__templater->formRow($__templater->escape($__vars['version']) . ' (' . $__templater->escape($__vars['distribution']) . ' ' . $__templater->escape($__vars['distributionVersion']) . ')', array(
				'label' => 'Version',
			)) . '

					';
			if ($__vars['stats']) {
				$__finalCompiled .= '
						';
				$__compilerTemp3 = '';
				if ($__vars['stats']['search']['query_total']) {
					$__compilerTemp3 .= '
										' . $__templater->func('parens', array('' . $__templater->func('number', array((($__vars['stats']['search']['query_time_in_millis'] + $__vars['stats']['search']['fetch_time_in_millis'])) / (($__vars['stats']['search']['query_total'] + $__vars['stats']['search']['fetch_total'])), ), false) . ' milliseconds average', ), true) . '
									';
				}
				$__finalCompiled .= $__templater->formRow('
							<dl class="pairs pairs--columns pairs--fixedSmall">
								<dt>' . 'Documents' . '</dt>
								<dd>' . $__templater->filter($__vars['stats']['docs']['count'], array(array('number', array()),), true) . ' ' . $__templater->func('parens', array($__templater->filter($__vars['stats']['store']['size_in_bytes'], array(array('file_size', array()),), false), ), true) . '</dd>
							</dl>
							<dl class="pairs pairs--columns pairs--fixedSmall">
								<dt>' . 'Index updates' . '</dt>
								<dd>' . $__templater->filter($__vars['stats']['indexing']['index_total'], array(array('number', array()),), true) . '</dd>
							</dl>
							<dl class="pairs pairs--columns pairs--fixedSmall">
								<dt>' . 'Searches' . '</dt>
								<dd>
									' . $__templater->filter($__vars['stats']['search']['query_total'], array(array('number', array()),), true) . '
									' . $__compilerTemp3 . '
								</dd>
							</dl>
							<dl class="pairs pairs--columns pairs--fixedSmall">
								<dt>' . 'Allocated memory' . '</dt>
								<dd>
									' . $__templater->filter($__vars['stats']['segments']['memory_in_bytes'], array(array('file_size', array()),), true) . '
								</dd>
							</dl>
						', array(
					'label' => 'Stats',
				)) . '
					';
			}
			$__finalCompiled .= '

					';
			if ($__vars['isOptimizable']) {
				$__finalCompiled .= '
						' . $__templater->formRow('
							' . 'Yes' . '
							' . $__templater->button('Optimize now', array(
					'href' => $__templater->func('link', array('enhanced-search/optimize', ), false),
					'data-xf-click' => 'overlay',
				), '', array(
				)) . '
							<div class="formRow-explain">' . 'Optimizing the index can reduce the amount of space required and improve performance.' . '</div>
						', array(
					'label' => 'Optimization required',
					'rowtype' => 'button',
				)) . '
					';
			} else {
				$__finalCompiled .= '
						' . $__templater->formRow('No', array(
					'label' => 'Optimization required',
				)) . '
					';
			}
			$__finalCompiled .= '
				';
		}
		$__finalCompiled .= '
			</div>
		</div>
	</div>

	' . $__templater->form('
		<div class="block-container">
			<h2 class="block-header">' . 'Search options' . '</h2>
			<div class="block-body">
				' . $__templater->formCheckBoxRow(array(
		), array(array(
			'name' => 'recencyWeighted',
			'selected' => $__vars['xf']['options']['xfesRecencyRelevance']['enabled'],
			'label' => 'Enable recency-weighted relevance searches',
			'_dependent' => array('
							<div class="inputGroup">
								<span class="inputGroup-text">' . 'Half-life' . $__vars['xf']['language']['label_separator'] . '</span>
								' . $__templater->formNumberBox(array(
			'name' => 'recencyHalfLife',
			'value' => ($__vars['xf']['options']['xfesRecencyRelevance']['halfLife'] ?: 365),
			'min' => '1',
		)) . '
								<span class="inputGroup-text">' . 'Days' . '</span>
							</div>
						'),
			'_type' => 'option',
		)), array(
			'explain' => 'If enabled, the search relevance algorithm will be weighted towards newer results based on the half-life value. A document submitted today will be twice as relevant as an identical one submitted a half-life ago.',
		)) . '

				<div class="formRowSep"></div>

				' . $__templater->formCheckBoxRow(array(
		), array(array(
			'name' => 'similarThreadsWidget',
			'selected' => $__vars['xf']['options']['xfesSimilarThreads']['widgetEnabled'],
			'label' => 'Enable similar threads widget',
			'_type' => 'option',
		)), array(
			'explain' => 'If enabled, the similar threads widget will be displayed in all its configured positions.',
		)) . '

				' . $__templater->formCheckBoxRow(array(
		), array(array(
			'name' => 'clear_similar_threads',
			'label' => 'Clear similar threads caches',
			'_type' => 'option',
		)), array(
			'explain' => 'If checked, the "Similar threads" widget caches will be cleared. The caches are built on-demand and updated periodically when a thread is viewed and the widget is active.',
		)) . '

				<div class="formRowSep"></div>

				' . $__templater->formCheckBoxRow(array(
		), array(array(
			'name' => 'similarThreadsSuggestions',
			'selected' => $__vars['xf']['options']['xfesSimilarThreads']['suggestionsEnabled'],
			'label' => 'Search for similar threads when users are creating new threads',
			'_dependent' => array('
							<div class="inputGroup">
								<span class="inputGroup-text">' . 'Maximum results' . ':</span>
								' . $__templater->formNumberBox(array(
			'name' => 'similarThreadsMax',
			'value' => ($__vars['xf']['options']['xfesSimilarThreads']['maxResults'] ?: 5),
			'min' => '1',
		)) . '
							</div>
						'),
			'_type' => 'option',
		)), array(
			'explain' => 'If enabled, a search for similar threads will be performed when users are creating new threads, and any results will be displayed beneath the title input.',
		)) . '

				' . $__templater->formRow('

					' . $__templater->callMacro(null, 'forum_selection_macros::select_forums', array(
			'nodeIds' => $__vars['xf']['options']['xfesSimilarThreadsExcludedForums'],
			'nodeTree' => $__vars['nodeTree'],
			'withRow' => false,
			'selectName' => 'similarThreadsExcludedForums',
		), $__vars) . '
				', array(
			'rowtype' => 'input',
			'label' => 'Do not suggest similar threads when composing in the following forums',
			'explain' => 'It may be futile or annoying to have similar thread suggestions appear when creating threads in some forums. This control allows specific forums to opt-out of the similar thread suggestion system.',
		)) . '

				<div class="formRowSep"></div>

				' . $__templater->formRow('
					<ul class="inputChoices inputChoices--noChoice">
						<li class="inputChoices-choice">
							<div></div>
							' . $__templater->formNumberBox(array(
			'name' => 'similarThreadsForumBoost',
			'value' => ($__vars['xf']['options']['xfesSimilarThreads']['forumBoost'] ?: 1),
			'min' => '1',
			'step' => 'any',
		)) . '
							<dfn class="inputChoices-explain">
								' . 'This allows similar thread results in the same forum as the original thread to be considered more relevant. Their relevancy score will be multiplied by the value entered here. Use 1 to disable this boosting.' . '
							</dfn>
						</li>
					</ul>
				', array(
			'label' => 'Same forum boost amount',
		)) . '
			</div>
			' . $__templater->formSubmitRow(array(
			'icon' => 'save',
		), array(
		)) . '
		</div>
	', array(
			'action' => $__templater->func('link', array('enhanced-search/options', ), false),
			'class' => 'block',
		)) . '

	';
		if ($__vars['analyzerConfig']) {
			$__finalCompiled .= '
		';
			if ($__vars['analyzerConfig']['unknown']) {
				$__finalCompiled .= '
			<div action="' . $__templater->func('link', array('enhanced-search/index-config', ), true) . '" class="block js-indexUnknownBlock">
				<div class="block-container">
					<h2 class="block-header">' . 'Index configuration' . '</h2>
					<div class="block-body block-row">
						' . 'The current index configuration represents a configuration not supported by XenForo. Updating the index options here will remove your existing configuration.' . '
						' . $__templater->button('Continue' . $__vars['xf']['language']['ellipsis'], array(
					'data-xf-click' => 'toggle',
					'data-target' => '.js-indexConfigForm',
					'data-hide' => '.js-indexUnknownBlock',
				), '', array(
				)) . '
					</div>
				</div>
			</div>
		';
			}
			$__finalCompiled .= '

		' . $__templater->form('
			<div class="block-container">
				<h2 class="block-header">' . 'Index configuration' . '</h2>
				<div class="block-body">
					' . $__templater->callMacro(null, 'xfes_macros::analyzer_config', array(
				'analyzerConfig' => $__vars['analyzerConfig'],
			), $__vars) . '
				</div>
				' . $__templater->formSubmitRow(array(
				'icon' => 'save',
			), array(
			)) . '
			</div>
		', array(
				'action' => $__templater->func('link', array('enhanced-search/index-config', ), false),
				'class' => 'block ' . ($__vars['analyzerConfig']['unknown'] ? 'toggleTarget js-indexConfigForm' : ''),
			)) . '
	';
		}
		$__finalCompiled .= '
';
	} else {
		$__finalCompiled .= '
	<div class="blockMessage">
		' . '<p>Enhanced search uses an Elasticsearch server to provide improved search functionality within XenForo. This includes relevancy sorting, searches for shorter words, support for stemming and customizable stop words, and improved performance.</p>

<p>Enhanced search requires Elasticsearch 2.0 or newer. Elasticsearch is a separate service which must be installed separately from your web server, PHP, and MySQL. Installation of Elasticsearch requires you to have root access to your server. Please speak to your server administrator for questions regarding Elasticsearch installation.</p>' . '
	</div>

	' . $__templater->callMacro(null, 'xfes_macros::config_form', array(), $__vars) . '
';
	}
	return $__finalCompiled;
}
);