<?php
// FROM HASH: 8c66caccfa735005ba9621f464fd2395
return array(
'code' => function($__templater, array $__vars, $__extensions = null)
{
	$__finalCompiled = '';
	$__finalCompiled .= ':root
{
	--f-carousel-theme-color: @xf-linkColor;
}

.carousel
{
	.m-clearFix();
	margin-bottom: calc(var(--f-carousel-dots-height) + @xf-elementSpacer);

	&.carousel--withFooter
	{
		margin-bottom: @xf-elementSpacer;
	}
}

.carousel-body
{
	&,
	&.f-carousel
	{
		--xf-slidesPerPage: 1;
		--f-carousel-spacing: @xf-paddingMedium;
	}

	display: flex;
	overflow: hidden;
	.m-listPlain();

	.carousel-container
	{
		flex: 0 0 auto;
		width: calc((100% - (var(--f-carousel-spacing) * (var(--xf-slidesPerPage) - 1))) / var(--xf-slidesPerPage));
		margin: 0 var(--f-carousel-spacing) 0 0;
	}

	@media (min-width: 700px)
	{
		&.carousel-body--show2
		{
			--xf-slidesPerPage: 2;
		}
	}
}

.carousel-item
{
	width: 100%;
	height: 100%;
	.xf-contentBase();
	.xf-blockBorder();
	border-radius: @xf-blockBorderRadius;
	padding: @xf-blockPaddingV @xf-blockPaddingH;
}

.carousel-footer
{
	position: relative;
	font-size: @xf-fontSizeSmall;
	z-index: @zIndex-1;

	margin-top: var(--f-carousel-dots-height);
	text-align: center;

	@media (min-width: @xf-responsiveNarrow)
	{
		margin-top: 0;
		text-align: right;
		line-height: var(--f-carousel-dots-height);
	}

}

:root
{
	--f-spinner-width: 36px;
	--f-spinner-height: 36px;
	--f-spinner-color-1: rgba(0, 0, 0, 0.1);
	--f-spinner-color-2: rgba(17, 24, 28, 0.8);
	--f-spinner-stroke: 2.75
}

.f-spinner
{
	margin: auto;
	padding: 0;
	width: var(--f-spinner-width);
	height: var(--f-spinner-height)
}

.f-spinner svg
{
	width: 100%;
	height: 100%;
	vertical-align: top;
	animation: f-spinner-rotate 2s linear infinite
}

.f-spinner svg *
{
	stroke-width: var(--f-spinner-stroke);
	fill: none
}

.f-spinner svg *:first-child
{
	stroke: var(--f-spinner-color-1)
}

.f-spinner svg *:last-child
{
	stroke: var(--f-spinner-color-2);
	animation: f-spinner-dash 2s ease-in-out infinite
}

@keyframes f-spinner-rotate
{
	100%
	{
		transform: rotate(360deg)
	}
}

@keyframes f-spinner-dash
{
	0%
	{
		stroke-dasharray: 1, 150;
		stroke-dashoffset: 0
	}
	50%
	{
		stroke-dasharray: 90, 150;
		stroke-dashoffset: -35
	}
	100%
	{
		stroke-dasharray: 90, 150;
		stroke-dashoffset: -124
	}
}

.f-throwOutUp
{
	animation: .175s ease-out both f-throwOutUp
}

.f-throwOutDown
{
	animation: .175s ease-out both f-throwOutDown
}

@keyframes f-throwOutUp
{
	to
	{
		transform: translate3d(0, -150px, 0);
		opacity: 0
	}
}

@keyframes f-throwOutDown
{
	to
	{
		transform: translate3d(0, 150px, 0);
		opacity: 0
	}
}

.f-zoomInUp
{
	animation: var(--f-transition-duration, 0.2s) ease-out .1s both f-zoomInUp
}

.f-zoomOutDown
{
	animation: var(--f-transition-duration, 0.2s) ease-out both f-zoomOutDown
}

@keyframes f-zoomInUp
{
	from
	{
		transform: scale(0.975) translate3d(0, 16px, 0);
		opacity: 0
	}
	to
	{
		transform: scale(1) translate3d(0, 0, 0);
		opacity: 1
	}
}

@keyframes f-zoomOutDown
{
	to
	{
		transform: scale(0.975) translate3d(0, 16px, 0);
		opacity: 0
	}
}

.f-fadeIn
{
	animation: var(--f-transition-duration, 0.2s) ease both f-fadeIn;
	z-index: 2
}

.f-fadeOut
{
	animation: var(--f-transition-duration, 0.2s) ease both f-fadeOut;
	z-index: 1
}

@keyframes f-fadeIn
{
	0%
	{
		opacity: 0
	}
	100%
	{
		opacity: 1
	}
}

@keyframes f-fadeOut
{
	100%
	{
		opacity: 0
	}
}

.f-fadeSlowIn
{
	animation: var(--f-transition-duration, 0.5s) ease both f-fadeSlowIn;
	z-index: 2
}

.f-fadeSlowOut
{
	animation: var(--f-transition-duration, 0.5s) ease both f-fadeSlowOut;
	z-index: 1
}

@keyframes f-fadeSlowIn
{
	0%
	{
		opacity: 0
	}
	100%
	{
		opacity: 1
	}
}

@keyframes f-fadeSlowOut
{
	100%
	{
		opacity: 0
	}
}

.f-fadeFastIn
{
	animation: var(--f-transition-duration, 0.2s) ease-out both f-fadeFastIn;
	z-index: 2
}

.f-fadeFastOut
{
	animation: var(--f-transition-duration, 0.2s) ease-out both f-fadeFastOut;
	z-index: 2
}

@keyframes f-fadeFastIn
{
	0%
	{
		opacity: .75
	}
	100%
	{
		opacity: 1
	}
}

@keyframes f-fadeFastOut
{
	100%
	{
		opacity: 0
	}
}

.f-crossfadeIn
{
	animation: var(--f-transition-duration, 0.2s) ease-out both f-crossfadeIn;
	z-index: 2
}

.f-crossfadeOut
{
	animation: calc(var(--f-transition-duration, 0.2s) * .5) linear .1s both f-crossfadeOut;
	z-index: 1
}

@keyframes f-crossfadeIn
{
	0%
	{
		opacity: 0
	}
	100%
	{
		opacity: 1
	}
}

@keyframes f-crossfadeOut
{
	100%
	{
		opacity: 0
	}
}

.f-slideIn.from-next
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-slideInNext
}

.f-slideIn.from-prev
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-slideInPrev
}

.f-slideOut.to-next
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-slideOutNext
}

.f-slideOut.to-prev
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-slideOutPrev
}

@keyframes f-slideInPrev
{
	0%
	{
		transform: translateX(100%)
	}
	100%
	{
		transform: translate3d(0, 0, 0)
	}
}

@keyframes f-slideInNext
{
	0%
	{
		transform: translateX(-100%)
	}
	100%
	{
		transform: translate3d(0, 0, 0)
	}
}

@keyframes f-slideOutNext
{
	100%
	{
		transform: translateX(-100%)
	}
}

@keyframes f-slideOutPrev
{
	100%
	{
		transform: translateX(100%)
	}
}

.f-classicIn.from-next
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-classicInNext;
	z-index: 2
}

.f-classicIn.from-prev
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-classicInPrev;
	z-index: 2
}

.f-classicOut.to-next
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-classicOutNext;
	z-index: 1
}

.f-classicOut.to-prev
{
	animation: var(--f-transition-duration, 0.85s) cubic-bezier(0.16, 1, 0.3, 1) f-classicOutPrev;
	z-index: 1
}

@keyframes f-classicInNext
{
	0%
	{
		transform: translateX(-75px);
		opacity: 0
	}
	100%
	{
		transform: translate3d(0, 0, 0);
		opacity: 1
	}
}

@keyframes f-classicInPrev
{
	0%
	{
		transform: translateX(75px);
		opacity: 0
	}
	100%
	{
		transform: translate3d(0, 0, 0);
		opacity: 1
	}
}

@keyframes f-classicOutNext
{
	100%
	{
		transform: translateX(-75px);
		opacity: 0
	}
}

@keyframes f-classicOutPrev
{
	100%
	{
		transform: translateX(75px);
		opacity: 0
	}
}

.f-carousel
{
	--f-carousel-theme-color: #706f6c;
	--f-carousel-spacing: 0px;
	--f-carousel-slide-width: 100%;
	--f-carousel-slide-height: auto;
	--f-carousel-slide-padding: 0;
	--f-button-width: 42px;
	--f-button-height: 42px;
	--f-button-color: var(--f-carousel-theme-color, currentColor);
	--f-button-hover-color: var(--f-carousel-theme-color, currentColor);
	--f-button-bg: transparent;
	--f-button-hover-bg: var(--f-button-bg);
	--f-button-active-bg: var(--f-button-bg);
	--f-button-svg-width: 24px;
	--f-button-svg-height: 24px;
	--f-button-next-pos: 10px;
	--f-button-prev-pos: 10px;
	position: relative;
	box-sizing: border-box
}

.f-carousel *, .f-carousel *:before, .f-carousel *:after
{
	box-sizing: inherit
}

.f-carousel.is-ltr
{
	direction: ltr
}

.f-carousel.is-rtl
{
	direction: rtl
}

.f-carousel__viewport
{
	overflow: hidden;
	transform: translate3d(0, 0, 0);
	backface-visibility: hidden;
	width: 100%;
	height: 100%
}

.f-carousel__viewport.is-draggable
{
	cursor: move;
	cursor: grab
}

.f-carousel__viewport.is-dragging
{
	cursor: move;
	cursor: grabbing
}

.f-carousel__track
{
	display: flex;
	margin: 0 auto;
	padding: 0;
	height: 100%;
	-webkit-tap-highlight-color: rgba(0, 0, 0, 0)
}

.f-carousel__slide
{
	position: relative;
	flex: 0 0 auto;
	width: var(--f-carousel-slide-width);
	max-width: 100%;
	height: var(--f-carousel-slide-height);
	margin: 0 var(--f-carousel-spacing) 0 0;
	padding: var(--f-carousel-slide-padding);
	overflow-x: hidden;
	overflow-y: auto;
	overscroll-behavior: contain;
	outline: 0;
	transform-origin: center center
}

.f-carousel__slide.is-loading
{
	min-height: 88px;
	min-width: 88px
}

.f-carousel.is-vertical
{
	--f-carousel-slide-height: 100%
}

.f-carousel.is-vertical .f-carousel__track
{
	flex-wrap: wrap
}

.f-carousel.is-vertical .f-carousel__slide
{
	margin: 0 0 var(--f-carousel-spacing) 0
}

:root
{
	--f-carousel-dots-width: 24px;
	--f-carousel-dots-height: 30px;
	--f-carousel-dot-width: 8px;
	--f-carousel-dot-height: 8px;
	--f-carousel-dot-radius: 50%;
	--f-carousel-dot-color: var(--f-carousel-theme-color, currentColor);
	--f-carousel-dot-opacity: 0.2;
	--f-carousel-dot-hover-opacity: 0.4
}

.f-carousel__dots
{
	position: absolute;
	bottom: calc(var(--f-carousel-dots-height) * -1);
	left: 0;
	right: 0;
	display: flex;
	justify-content: center;
	align-items: center;
	flex-wrap: wrap;
	margin: 0 auto !important;
	padding: 0;
	list-style: none !important;
	user-select: none
}

.f-carousel__dots li
{
	margin: 0;
	padding: 0;
	border: 0;
	display: flex;
	align-items: center;
	justify-content: center;
	opacity: var(--f-carousel-dot-opacity);
	transition: opacity .15s ease-in-out
}

.f-carousel__dots li + li
{
	margin: 0
}

.f-carousel__dots li:hover
{
	opacity: var(--f-carousel-dot-hover-opacity)
}

.f-carousel__dots li.is-current
{
	opacity: 1
}

.f-carousel__dots li button
{
	appearance: none;
	display: flex;
	align-items: center;
	justify-content: center;
	margin: 0;
	padding: 0;
	width: var(--f-carousel-dots-width);
	height: var(--f-carousel-dots-height);
	border: 0;
	background: rgba(0, 0, 0, 0);
	cursor: pointer;
	transition: all .2s linear
}

.f-carousel__dot
{
	display: block;
	margin: 0;
	padding: 0;
	border: 0;
	width: var(--f-carousel-dot-width);
	height: var(--f-carousel-dot-height);
	border-radius: var(--f-carousel-dot-radius);
	background-color: var(--f-carousel-dot-color);
	line-height: 0;
	font-size: 0;
	cursor: pointer;
	pointer-events: none
}

.f-carousel__dots.is-dynamic li:not(.is-prev,.is-next,.is-current,.is-after-next,.is-before-prev) button
{
	transform: scale(0);
	width: 0
}

.f-carousel__dots.is-dynamic li.is-before-prev button, .f-carousel__dots.is-dynamic li.is-after-next button
{
	transform: scale(0.22)
}

.f-carousel__dots.is-dynamic li.is-prev button, .f-carousel__dots.is-dynamic li.is-next button
{
	transform: scale(0.66)
}

.f-carousel__dots.is-dynamic li.is-current button
{
	transform: scale(1)
}

.f-carousel__dots.is-dynamic li.is-before-prev button, .f-carousel__dots.is-dynamic li.is-after-next button
{
	transform: scale(0.33)
}

.f-carousel__dots.is-dynamic li.is-current:first-child
{
	margin-left: calc(var(--f-carousel-dots-width) * 2)
}

.f-carousel__dots.is-dynamic li.is-prev:first-child
{
	margin-left: var(--f-carousel-dots-width)
}

.f-carousel__dots.is-dynamic li.is-next:last-child
{
	margin-right: var(--f-carousel-dots-width)
}

.f-carousel__dots.is-dynamic li.is-current:last-child
{
	margin-right: calc(var(--f-carousel-dots-width) * 2)
}

.f-carousel.is-rtl .f-carousel__dots.is-dynamic .is-current:first-child
{
	margin-left: 0;
	margin-right: var(--f-carousel-dots-width)
}

.f-carousel.is-rtl .f-carousel__dots.is-dynamic .is-prev:first-child
{
	margin-left: 0;
	margin-right: var(--f-carousel-dots-width)
}

.f-carousel.is-rtl .f-carousel__dots.is-dynamic .is-current:last-child
{
	margin-left: 0;
	margin-right: var(--f-carousel-dots-width)
}

.f-carousel.is-rtl .f-carousel__dots.is-dynamic .is-next:last-child
{
	margin-right: 0;
	margin-left: var(--f-carousel-dots-width)
}

:root
{
	--f-button-width: 40px;
	--f-button-height: 40px;
	--f-button-border: 0;
	--f-button-border-radius: 0;
	--f-button-color: #374151;
	--f-button-bg: #f8f8f8;
	--f-button-hover-bg: #e0e0e0;
	--f-button-active-bg: #d0d0d0;
	--f-button-shadow: none;
	--f-button-transition: all 0.15s ease;
	--f-button-transform: none;
	--f-button-svg-width: 20px;
	--f-button-svg-height: 20px;
	--f-button-svg-stroke-width: 1.5;
	--f-button-svg-fill: none;
	--f-button-svg-filter: none;
	--f-button-svg-disabled-opacity: 0.65
}

.f-button
{
	display: flex;
	justify-content: center;
	align-items: center;
	box-sizing: content-box;
	position: relative;
	margin: 0;
	padding: 0;
	width: var(--f-button-width);
	height: var(--f-button-height);
	border: var(--f-button-border);
	border-radius: var(--f-button-border-radius);
	color: var(--f-button-color);
	background: var(--f-button-bg);
	box-shadow: var(--f-button-shadow);
	pointer-events: all;
	cursor: pointer;
	transition: var(--f-button-transition)
}

@media (hover: hover)
{
	.f-button:hover:not([disabled])
	{
		color: var(--f-button-hover-color);
		background-color: var(--f-button-hover-bg)
	}
}

.f-button:active:not([disabled])
{
	background-color: var(--f-button-active-bg)
}

.f-button:focus:not(:focus-visible)
{
	outline: none
}

.f-button:focus-visible
{
	outline: none;
	box-shadow: inset 0 0 0 var(--f-button-outline, 2px) var(--f-button-outline-color, var(--f-button-color))
}

.f-button svg
{
	width: var(--f-button-svg-width);
	height: var(--f-button-svg-height);
	fill: var(--f-button-svg-fill);
	stroke: currentColor;
	stroke-width: var(--f-button-svg-stroke-width);
	stroke-linecap: round;
	stroke-linejoin: round;
	transition: opacity .15s ease;
	transform: var(--f-button-transform);
	filter: var(--f-button-svg-filter);
	pointer-events: none
}

.f-button[disabled]
{
	cursor: default
}

.f-button[disabled] svg
{
	opacity: var(--f-button-svg-disabled-opacity)
}

.f-carousel__nav .f-button.is-prev, .f-carousel__nav .f-button.is-next, .fancybox__nav .f-button.is-prev, .fancybox__nav .f-button.is-next
{
	position: absolute;
	z-index: 1
}

.is-horizontal .f-carousel__nav .f-button.is-prev, .is-horizontal .f-carousel__nav .f-button.is-next, .is-horizontal .fancybox__nav .f-button.is-prev, .is-horizontal .fancybox__nav .f-button.is-next
{
	top: 50%;
	transform: translateY(-50%)
}

.is-horizontal .f-carousel__nav .f-button.is-prev, .is-horizontal .fancybox__nav .f-button.is-prev
{
	left: var(--f-button-prev-pos)
}

.is-horizontal .f-carousel__nav .f-button.is-next, .is-horizontal .fancybox__nav .f-button.is-next
{
	right: var(--f-button-next-pos)
}

.is-horizontal.is-rtl .f-carousel__nav .f-button.is-prev, .is-horizontal.is-rtl .fancybox__nav .f-button.is-prev
{
	left: auto;
	right: var(--f-button-next-pos)
}

.is-horizontal.is-rtl .f-carousel__nav .f-button.is-next, .is-horizontal.is-rtl .fancybox__nav .f-button.is-next
{
	right: auto;
	left: var(--f-button-prev-pos)
}

.is-vertical .f-carousel__nav .f-button.is-prev, .is-vertical .f-carousel__nav .f-button.is-next, .is-vertical .fancybox__nav .f-button.is-prev, .is-vertical .fancybox__nav .f-button.is-next
{
	top: auto;
	left: 50%;
	transform: translateX(-50%)
}

.is-vertical .f-carousel__nav .f-button.is-prev, .is-vertical .fancybox__nav .f-button.is-prev
{
	top: var(--f-button-next-pos)
}

.is-vertical .f-carousel__nav .f-button.is-next, .is-vertical .fancybox__nav .f-button.is-next
{
	bottom: var(--f-button-next-pos)
}

.is-vertical .f-carousel__nav .f-button.is-prev svg, .is-vertical .f-carousel__nav .f-button.is-next svg, .is-vertical .fancybox__nav .f-button.is-prev svg, .is-vertical .fancybox__nav .f-button.is-next svg
{
	transform: rotate(90deg)
}';
	return $__finalCompiled;
}
);